# PowerShell 脚本：find_vid_pid.ps1
# 查找含有 VID_2F0A&PID_1064 的 INF 文件

$target = "VID_2F0A&PID_1064"
$encodings = @("utf8", "unicode", "default")

foreach ($file in Get-ChildItem "C:\Windows\INF\oem*.inf") {
    foreach ($enc in $encodings) {
        try {
            $text = Get-Content -Path $file.FullName -Encoding $enc -ErrorAction Stop
            if ($text -match $target) {
                Write-Output $file.Name
                exit 0
            }
        } catch {
            continue
        }
    }
}
exit 1  # 如果没有找到